/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dto.LoginDto;
import com.dto.SellerDetailDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TextNormalizer;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository
public class SellerDetailDao {
    private final DbConnection dbConnection;

    public SellerDetailDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public LoginDto login() {
        return this.dbConnection.setToken();
    }

    public Map<String, Object> getCustomerSellerState(String cCode, LoginDto login) {
        return this.dbConnection.getJdbcTemplate(login).queryForMap(" SELECT ISNULL(IsSeller, 0) IsSeller FROM CUSTOMER WHERE C_CODE = ?", new Object[]{cCode});
    }

    public boolean productNotExist(String a_code, LoginDto login) {
        Integer count = (Integer)this.dbConnection.getJdbcTemplate(login).queryForObject(" SELECT COUNT(*) cnt FROM ARTICLE  WHERE A_CODE = ?", Integer.class, new Object[]{a_code});
        return count == null || count == 0;
    }

    public String findProductCodeByCMSId(Long cmsId, LoginDto login) {
        if (cmsId == null) {
            return null;
        }
        SqlRowSet rowSet = this.dbConnection.getJdbcTemplate(login).queryForRowSet(" SELECT A_CODE FROM ARTICLE  WHERE CMS_ID = ?", new Object[]{cmsId});
        if (rowSet.next()) {
            return rowSet.getString("A_Code");
        }
        throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
    }

    public void insert(SellerDetailDto dto, LoginDto login) {
        this.dbConnection.getTransactionTemplate(login).executeWithoutResult(transactionStatus -> {
            try {
                this.dbConnection.getJdbcTemplate(login).update(" INSERT INTO SellerDetail (C_CODE, A_CODE, COMMISSION, SELL_PRICE, ContractNumber) VALUES (?, ?, ?, ?, ?)", new Object[]{dto.getCustomerCode(), dto.getProductCode(), dto.getCommission(), dto.getSellPrice(), dto.getContractNumber()});
            }
            catch (Exception e) {
                transactionStatus.setRollbackOnly();
                throw new RuntimeException(e);
            }
        });
    }

    public void update(SellerDetailDto dto, LoginDto login) {
        this.dbConnection.getTransactionTemplate(login).executeWithoutResult(transactionStatus -> {
            try {
                this.dbConnection.getJdbcTemplate(login).update(" UPDATE SellerDetail set COMMISSION = IsNull(" + dto.getCommission() + ", COMMISSION),  SELL_PRICE = IsNull(" + dto.getSellPrice() + ", SELL_PRICE), \n ContractNumber = IsNull(" + ConvertStr.toQuotedSql((Object)dto.getContractNumber()) + ", ContractNumber) \n WHERE C_CODE = ? AND A_CODE = ?", new Object[]{dto.getCustomerCode(), dto.getProductCode()});
            }
            catch (Exception e) {
                transactionStatus.setRollbackOnly();
                throw new RuntimeException(e);
            }
        });
    }

    public SellerDetailDto getSellerDtl(String cCode, String aCode, LoginDto login) {
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(" SELECT [ID], C_CODE, A_CODE, COMMISSION, SELL_PRICE  FROM SellerDetail WHERE C_CODE = ? AND A_CODE = ?", new Object[]{cCode, aCode});
        if (!rs.next()) {
            return null;
        }
        return SellerDetailDto.builder().id(Objects.requireNonNull(rs.getBigDecimal("ID")).longValue()).commission(Double.valueOf(rs.getDouble("COMMISSION"))).sellPrice(Double.valueOf(rs.getDouble("SELL_PRICE"))).customerCode(rs.getString("C_CODE")).productCode(rs.getString("A_CODE")).build();
    }

    public ResponseEntity<?> getSellerDtlList(HttpServletRequest request) {
        String sqlWhere = "";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        if (info.containsKey("cms_id")) {
            sqlWhere = " WHERE A.cms_id = " + (String)info.get("cms_id");
            if (info.containsKey("nationalcode")) {
                sqlWhere = sqlWhere + " AND C.National_Code = '" + (String)info.get("nationalcode") + "'";
            }
        }
        if (sqlWhere.isEmpty() && info.containsKey("nationalcode")) {
            sqlWhere = " WHERE C.National_Code = '" + (String)info.get("nationalcode") + "'";
        }
        String sql = "SELECT A.cms_id, C.National_Code, S.Commission, S.Sell_Price, S.ContractNumber FROM SellerDetail S\nINNER JOIN ARTICLE A ON A.A_Code = S.A_Code\nINNER JOIN CUSTOMER C ON C.C_Code = S.C_Code\n" + sqlWhere;
        List rowSet = this.dbConnection.getJdbcTemplate(this.login()).queryForList(sql);
        return ConvertStr.getMapResponseEntity((String)"Seller", (List)rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }
}

